#ifndef DDIALOGO_MODAL
    #define DDIALOGO_MODAL

    #include "DEventosPadre.h"
 
    namespace DWL {

        class DDialogoModal : public DEventosPadre<INT_PTR> {
		    public : ///////////////////////////// -Declaraciones publicas

								                //! Constructor  
                                                /*! Constructor por defecto.
									                    \fn			DDialogoModal(void);
                                                        \return     No devuelve nada
                                                */
                                                DDialogoModal(void) : DEventosPadre<INT_PTR>() { };

								                //! Destructor  
                                                /*! Destructor por defecto.
									                    \fn		   ~DDialogoModal(void);
                                                        \return     No devuelve nada
                                                */
								               ~DDialogoModal(void);

							                    //! Funcin que crea el dialogo.
							                    /*!	Esta funcin crea el dialogo.
									                    \fn			HWND Crear(int ID_Dialogo, DBaseWnd *nPadre = NULL);
									                    \param[in]	ID_Dialogo	    ID del dialogo en los recursos.
                                                        \param[in]	nPadre    	    Clase DBaseWnd que hace de padre (NULL en caso de ser un dialogo padre)
									                    \return		Esta funcin no devuelve nada
							                    */
	         void	                            Crear(int ID_Dialogo, DBaseWnd *nPadre = NULL);

									            //! Funcin que destruye este dialogo
									            /*!	Esta funcion destruye este dialogo
											            \fn			virtual BOOL Destruir(void);
											            \return		Devuelve TRUE si la operacin se completo, FALSE en caso contrario.
                                                        \remarks    A diferencia de las funciones Destruir por defecto, esta funcin utiliza la API EndDialog en vez de la API DestroyWindow.
									            */
             virtual BOOL                       Destruir(void);

							                    //! Funcin virtual para determinar si la ventana es maximizable.
							                    /*! Esta funcin virtual determina si la ventana es maximizable.
									                    \fn			virtual void Maximizable(const bool nMax);
									                    \param[in]	nMax : Especifica true para que la ventana sea maximizable, false para lo contrario.
									                    \return		Esta funcin no devuelve nada.
							                    */
		    virtual void                        Maximizable(const bool nMax);

							                    //! Funcin virtual que nos dice si la ventana es maximizable.
							                    /*! Esta funcin virtual nos dice si la ventana es maximizable.
									                    \fn			virtual const bool Maximizable(void);
									                    \return		Devuelve true si la ventana es maximizable, false en caso contrario.
							                    */
		    virtual const bool                  Maximizable(void);

							                    //! Funcin que nos dice si la ventana esta maximizada en este momento.
							                    /*! Esta funcin nos dice si la ventana esta maximizada en este momento.
									                    \fn			const bool Maximizada(void);
									                    \return		Devuelve true si la ventana esta maximizada, false en caso contrario.
							                    */
            const bool				            Maximizada(void);

							                    //! Funcin virtual para determinar si la ventana es minimizable.
							                    /*! Esta funcin virtual determina si la ventana es minimizable.
									                    \fn			virtual void Minimizable(const bool nMin);
									                    \param[in]	nMin : Especifica true para que la ventana sea minimizable, false para lo contrario.
									                    \return		Esta funcin no devuelve nada.
							                    */
		    virtual void                        Minimizable(const bool nMin);

							                    //! Funcin virtual que nos dice si la ventana es minimizable.
							                    /*! Esta funcin virtual nos dice si la ventana es minimizable.
									                    \fn			virtual const bool Minimizable(void);
									                    \return		Devuelve true si la ventana es minimizable, false en caso contrario.
							                    */
		    virtual const bool                  Minimizable(void);

							                    //! Funcin que nos dice si la ventana esta minimizada en este momento.
							                    /*! Esta funcin nos dice si la ventana esta minimizada en este momento.
									                    \fn			const bool Minimizada(void);
									                    \return		Devuelve true si la ventana esta minimizada, false en caso contrario.
							                    */
		    const bool				            Minimizada(void);

							                    //! Funcin para posicionar la ventana siempre delante de todas las otras ventanas.
							                    /*! Esta funcin posiciona la ventana siempre delante de todas las otras ventanas.
									                    \fn			virtual void SiempreDelante(const bool SD);
									                    \param[in]	SD : Especifica true para que la ventana quede siempre por delante, false para que tenga un comportamiento normal segun su coordenada Z.
									                    \return		Esta funcin no devuelve nada.
                                                        \remarks    Por norma las ventanas se posicionan utilizando el OrdenZ, que es un indice para determinar en que posicin estan las ventanas. 
                                                                    Si por ejemplo creas dos ventanas la primera se pondra en el orden 1, y la segunda en el orden 0, 
                                                                    de forma que si se crean en cascada deberias ver la segunda ventana por delante de todo.
							                    */
		    virtual void				        SiempreDelante(const bool SD);

							                    //! Funcin para asignar el titulo de la ventana.
							                    /*! Esta funcin asigna el titulo de la ventana.
									                    \fn			virtual void Titulo(const TCHAR *Txt);
									                    \param[in]	Txt : Nuevo texto para el titulo de la ventana.
									                    \return		Esta funcin no devuelve nada.
							                    */
		    virtual void		   		        Titulo(const TCHAR *Txt);

							                    //! Funcin para obtener el titulo de la ventana.
							                    /*! Esta funcin obtiene el titulo de la ventana en el buffer especificado.
									                    \fn			int Titulo(TCHAR *Txt, const int TamTxt);
									                    \param[in]	Txt    : Buffer de texto para obtener el titulo.
                                                        \param[in]  TamTxt : Tamao del buffer para el titulo.
									                    \return		Esta funcin devuelve 0 en caso de error. En caso de exito devuelve el numero de caracteres que contiene el titulo sin incluir el terminador NULL.
							                    */
		    int						            Titulo(TCHAR *Txt, const int TamTxt);

                                                //! Funcin que devuelve que tipo de clase BaseWnd es esta clase
                                                /*! Esta funcin devuelve que tipo de clase BaseWnd es esta clase
                                                        \fn         virtual const DEnum_TipoBaseWnd TipoBaseWnd(void);
                                                        \returns    Devuelve un valor de DEnum_TipoBaseWnd
                                                        \remars     Esta funcin identifica que tipo de ventana o control se esta utilizando.
                                                */
            virtual const DEnum_TipoBaseWnd     TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_DialogoModal; };

            virtual const TCHAR                *Objeto_Nombre(void) { return TEXT("DDialogoModal"); };
            virtual const DEnum_Objeto          Objeto_ID(void)     { return DEnum_Objeto_DialogoModal; };

            virtual INT_PTR                     Evento_Cerrar(void) { Destruir(); return 0; };

          protected: ///////////////////////////// -Declaraciones protegidas (Solo podran usarse en la clase heredada no desde fuera)

								                //! Esqueleto inicial que enlaza esta clase con la ventana.
								                /*! Esta funcin es el esqueleto inicial que enlaza esta clase con el dialogo.
										                \fn			static INT_PTR CALLBACK _GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam);
										                \param[in]	hWndDialogo      Identificador de ventana.
										                \param[in]	uMsg			 Mensaje.
										                \param[in]	wParam			 Parametro1.
										                \param[in]	lParam			 Parametro2.
										                \return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
								                */
            static INT_PTR CALLBACK            _GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam);
	    };			     			            //
	    ////////////////////////////////////////// Fin DDialogoModal


    };

#endif // DDIALOGO_MODAL
